/******************************************************************************
* Technical University of Darmstadt
* Industrial Process and System Communication
* Project: TCP
* Filename: TcpStarter.java
* Author: Gunter Weiss
* Last Changes: 25/4/97 by the Author
* Contents: Mainclass, initializes all subclasses.
******************************************************************************/

import misc.Debug;
import java.awt.*;
import java.util.Vector;
import java.net.URL;
import java.util.Date;

/******************************************************************************
* Class: TcpStarter
* Description: A TcpStarter object controls all subclasses. Therefore it
*              launches two control-threads.
******************************************************************************/
public class TcpStarter {

  TcpApplet parent = null;
  public final int maxapp=2;  // Anzahl der max.Applikationen auf dem Host
  public static URL home;
  int screenfactor = 1;       // to change screen resolutions
  int counter = 0;
  int steps = 0;
  int timeouttime = 10000;
  int timertime = 5000;
  int keepalivetimeout_time = 20000;
  int conid1, conid2, suc1, suc2;
  short localport = 23;
  short destport = 23;
  public boolean singlestep = false;
boolean sleeping;

  Host host1, host2;
  FromAtoB ch_1,ch_2;
  FSMWindow fsm_window;

  HostNetBuffer  host1in  = new HostNetBuffer();
  HostNetBuffer  host1out = new HostNetBuffer();
  HostNetBuffer  host2in  = new HostNetBuffer();
  HostNetBuffer  host2out = new HostNetBuffer();
  CheckStatus chkstat = new CheckStatus();
  public static ThreadGroup halt;


// Start als Applikation
  public TcpStarter() {
    ch_1 = new FromAtoB(this, host1out,  host2in);
    ch_2 = new FromAtoB(this, host2out, host1in);
    host1 = new Host(this, "Host1",host1out,host1in,1);
    host2 = new Host(this, "Host2",host2out,host2in,2);
    chkstat.CheckStatus(this);
    //Initialisierung der Applikationen
  }

// Start als Applet
  public TcpStarter( TcpApplet target ) {

    this.parent = target;
    ch_1 = new FromAtoB(this, host1out,  host2in);
    ch_2 = new FromAtoB(this, host2out, host1in);
    host1 = new Host(this, "Host1",host1out,host1in,1);
    host2 = new Host(this, "Host2",host2out,host2in,2);
    chkstat. CheckStatus(this);
    TcpSegment dummyserv = new TcpSegment();
    host1. t1.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,"CLOSED"));
    host2. t1.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(dummyserv,true,new Date().getTime(),true,"CLOSED"));
    sleeping = true;
        conid2 = host2.t1.Open(localport,destport,0);
        if (conid2 >= 0) {
	    System. out.println("Server erfolgreich im LISTEN");
            conid1= host1.t1.Open(localport,destport,1);
            if (conid1 >= 0) {
	      System. out.println("Verbindung erfolgreich aufgebaut" + conid1);
	      Sleeper sleep = new Sleeper(this);
	      int state1 = host1.getStatus().TcpStatus;
	      int state2 = host2.getStatus().TcpStatus;
		suc1 = host1.t1.Close(conid1);
		System. out.println("History-Gre:host1: " + host1.t1.history.size() + " host2: " + host2.t1.history.size() + "conid2" + conid2 );
		if (suc1 == 0) {
		  System. out.println("Client Close() OK "); 
		  suc2 = host2.t1.Close(conid2);
		  if (suc2 == 0){
		    System. out.println("Server Close() OK ");
		    System. out.println("ffnen der State Machine");
		    System. out.println("History-Gre:host1: " + host1.t1.history.size() + " host2: " + host2.t1.history.size());
		    fsm_window = new FSMWindow(this, host1, host2);
		  }
		}
	      }
	    }
	}

  


/******************************************************************************
* Method: main
* Description: creates TcpStarter object
* Parameters: none
* Return Value: none
******************************************************************************/
  public static void main(String args[]) {
  }
/******************************************************************************
* Method: sleepout
* Description: called by Sleeper Thread
* Parameters: none
* Return Value: boolean
******************************************************************************/
  public synchronized sleepout() {
    sleeping == false ;
    notify;
  }
}

